# Contains methods common to the GameMapScanner and FastScreenShotScanner
import time
import pyautogui


class BaseClass:

    def __init__(self, config):
        self.config = config
        self.screen_w = pyautogui.size()[0]
        self.screen_h = pyautogui.size()[1]
        self.screenshots = []
        self.is_running = False
        self.map_data = {}
        self.scan_count = 0
        self.skip_count = 0
        self.last_x = None
        self.skip_types = set()
        self.skip_cords = set()
        self.skip_regions = []
        self.multi_tile_objects = {}
        self.is_running = False

    def _percent_to_pixel(self, percent_x, percent_y):
        """Convert percentage to pixel coordinates"""
        return int(percent_x * self.screen_w), int(percent_y * self.screen_h)

    def _percent_region_to_pixel(self, region):
        """Convert percentage region to pixel region"""
        x, y, w, h = region
        return (
            int(x * self.screen_w),
            int(y * self.screen_h),
            int(w * self.screen_w),
            int(h * self.screen_h)
        )

    def enter_coordinates(self, x, y):
        """Enter coordinates using percentage-based positions"""
        coord_screen = self._percent_to_pixel(*self.config['coordinate_screen'])
        pyautogui.click(*coord_screen)
        time.sleep(0.5)

        if self.last_x != x:
            x_input = self._percent_to_pixel(*self.config['x_input'])
            pyautogui.click(*x_input)
            time.sleep(0.2)
            pyautogui.press('backspace', presses=4, interval=0.01)
            time.sleep(0.2)
            pyautogui.write(str(x), interval=0.05)
            time.sleep(0.1)
            self.last_x = x

        y_input = self._percent_to_pixel(*self.config['y_input'])
        pyautogui.click(*y_input)
        time.sleep(0.2)
        pyautogui.press('backspace', presses=4, interval=0.01)
        time.sleep(0.2)
        pyautogui.write(str(y), interval=0.05)
        time.sleep(0.1)

        confirm = self._percent_to_pixel(*self.config['confirm_button'])
        pyautogui.click(*confirm)
        time.sleep(0.5)

